package com.digiwin.dap.middle.tx.stream.service.impl;

import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.mapper.TransactionMessageMapper;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.util.EntityUtils;
import com.digiwin.dap.middleware.util.SnowFlake;
import com.github.pagehelper.PageHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;
import java.util.List;

@Service
public class TransactionMessageServiceImpl implements TransactionMessageService {

    @Autowired
    private TransactionMessageMapper transactionMessageMapper;

    @Override
    public void deleteTransactionMessage(long sid) {
        transactionMessageMapper.deleteTransactionMessage(sid);
    }

    @Override
    public int updateTransactionMessageStatusToSending(long sid) {
        return transactionMessageMapper.updateTransactionMessageStatusToSending(sid);
    }

    @Override
    public List<TransactionMessage> selectPendingTransactionMessage(int pageSize, int maxRetryCount) {
        PageHelper.startPage(1, pageSize, false);
        return transactionMessageMapper.selectPendingTransactionMessage(maxRetryCount, LocalDateTime.now());
    }

    @Override
    public void insertTransactionMessage(TransactionMessage message) {
        EntityUtils.setCreateFields(message);
        message.setSid(SnowFlake.getInstance().newId());
        transactionMessageMapper.insertTransactionMessage(message);
    }

    @Override
    public int updateTransactionMessageStatusToPending(long sid, LocalDateTime sendTime) {
        return transactionMessageMapper.updateTransactionMessageStatusToPending(sid, sendTime);
    }
}
