CREATE TABLE transaction_message
(
    sid             BIGINT(20) NOT NULL,
    content         TEXT        NOT NULL COMMENT '消息内容',
    status          VARCHAR(32) NOT NULL COMMENT '状态',
    retry_count     BIGINT(20) DEFAULT 0 COMMENT '推送次数',
    send_time       DATETIME    NOT NULL COMMENT '发送时间',
    create_by       BIGINT(20) DEFAULT 0,
    create_date     DATETIME     DEFAULT NULL,
    create_org      BIGINT(20) DEFAULT 0,
    create_provider BIGINT(20) DEFAULT 0,
    deleted         BIT(1)       DEFAULT b'0',
    disabled        BIT(1)       DEFAULT b'0',
    hash            VARCHAR(40)  DEFAULT NULL,
    modify_by       BIGINT(20) DEFAULT 0,
    modify_date     DATETIME     DEFAULT NULL,
    modify_provider BIGINT(20) DEFAULT 0,
    create_by_id    VARCHAR(255) DEFAULT NULL,
    modify_by_id    VARCHAR(255) DEFAULT NULL,
    PRIMARY KEY (sid),
    KEY             idx_status_retry_count_send_time (status,retry_count,send_time)
);