package com.digiwin.dap.middle.tx.stream.producer;

import com.digiwin.dap.middle.stream.domain.MessageBody;
import com.digiwin.dap.middle.stream.domain.MessageType;
import com.digiwin.dap.middle.stream.service.ProducerService;
import com.digiwin.dap.middle.tx.stream.domain.TxMessageStatus;
import com.digiwin.dap.middle.tx.stream.entity.TransactionMessage;
import com.digiwin.dap.middle.tx.stream.service.TransactionMessageService;
import com.digiwin.dap.middleware.domain.DapEnv;
import com.digiwin.dap.middleware.util.JsonUtils;
import com.digiwin.dap.middleware.util.UserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.time.LocalDateTime;

@Service
public class TxProducerServiceImpl implements TxProducerService {

    @Autowired
    private DapEnv dapEnv;
    @Autowired
    private ProducerService producerService;
    @Autowired
    private TransactionMessageService transactionMessageService;

    @Override
    public void internal(MessageBody messageInfo) {
        internal(messageInfo, false);
    }

    @Override
    public void internal(MessageBody messageInfo, boolean transaction) {
        internal(messageInfo, transaction, LocalDateTime.now());
    }

    @Override
    public void internal(MessageBody messageBody, boolean transaction, LocalDateTime sendTime) {
        if (transaction) {
            messageBody.setSourceId(dapEnv.getAppName());
            messageBody.setMsgType(MessageType.INTERNAL);
            if (messageBody.getUserToken() == null) {
                messageBody.setUserToken(UserUtils.getToken());
            }
            TransactionMessage txMessage = new TransactionMessage();
            txMessage.setContent(JsonUtils.objToJson(messageBody));
            txMessage.setStatus(TxMessageStatus.PENDING.name());
            txMessage.setSendTime(sendTime);
            txMessage.setRetryCount(0);
            transactionMessageService.insertTransactionMessage(txMessage);
        } else {
            producerService.internal(messageBody);
        }
    }
}
