package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;

/**
 * Fluent builder for DMC Client. Use of the builder is preferred over using
 * constructors of the client class.
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public final class DMCClientBuilder implements DMCBuilder {

    /**
     * 延时登录认证，防止影响项目启动
     */
    private final boolean lazy;

    public DMCClientBuilder(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public DMC build() {
        DMCConfig config = DMCConfigBuilder.create()
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String tenantId) {
        DMCConfig config = DMCConfigBuilder.create()
                .tenantId(tenantId)
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMC client, String tenantId) {
        client.switchTenantId(tenantId);
        return client;
    }

    @Override
    public DMC build(String uri, String username, String password, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .appToken(appToken).appSecret(appSecret)
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String tenantId, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .tenantId(tenantId)
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String tenantId, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .appToken(appToken).appSecret(appSecret)
                .tenantId(tenantId)
                .lazy(lazy)
                .build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMCConfig config) {
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMCConfig config, ClientConfiguration clientConfig) {
        return new DMCClient(config, clientConfig);
    }
}
