package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;

/**
 * DMCEncryptionClient is used to do client-side encryption.
 *
 * @author michael
 * @since 5.3.0.0
 */
public class DMCEncryptionClientBuilder {

    /**
     * 延时登录认证，防止影响项目启动
     */
    private final boolean lazy;


    public DMCEncryptionClientBuilder(boolean lazy) {
        this.lazy = lazy;
    }

    public static DMCEncryptionClientBuilder create() {
        return new DMCEncryptionClientBuilder(true);
    }

    public DMC build() {
        DMCConfig config = DMCConfigBuilder.create()
                .lazy(lazy)
                .build();
        return new DMCEncryptionClient(config);
    }


    public DMC build(String uri, String username, String password, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .lazy(lazy)
                .build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .appToken(appToken).appSecret(appSecret)
                .lazy(lazy)
                .build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String tenantId, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .tenantId(tenantId)
                .lazy(lazy)
                .build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String tenantId, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket)
                .appToken(appToken).appSecret(appSecret)
                .tenantId(tenantId)
                .lazy(lazy)
                .build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(DMCConfig config) {
        return new DMCEncryptionClient(config);
    }

    public DMC build(DMCConfig config, ClientConfiguration clientConfig) {
        return new DMCClient(config, clientConfig);
    }
}
