package com.digiwin.dap.middleware.dmc.common.parser;

import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.internal.model.StdError;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * Used to convert an result stream to a java object.
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class ErrorResponseParser implements ResponseParser<StdError> {

    private static final Logger logger = LoggerFactory.getLogger(ErrorResponseParser.class);

    @Override
    public StdError parse(ResponseMessage response) throws ResponseParseException {
        StdError stdError = JsonUtils.readValue(response.getError(), StdError.class);
        if (stdError == null) {
            logger.error("Unable convert response error message to StdError:{}", response.getError());
        }
        return stdError;
    }
}
