package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;

import java.io.File;
import java.util.Objects;

public abstract class AbstractEncryptionStrategy<T> implements EncryptionStrategy<T>{

   protected final byte[] aesKey;

    public AbstractEncryptionStrategy(byte[] aesKey) {
        this.aesKey = aesKey;
    }

    protected void check(T t){
        if(Objects.isNull(t)){
            throw new DMCException("加密对象为null!");
        }
        if(t instanceof File && (!((File) t).exists() || ((File) t).length() <= 0)){
            throw new DMCException("加密File为空!");
        }
        if(t instanceof byte[] && (((byte[]) t).length <= 0)){
            throw new DMCException("加密byte[]为空!");
        }
    }

}
