package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.commons.crypto.AES;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ByteArrayEncryptionStrategy extends AbstractEncryptionStrategy<byte[]> {

    protected static final Logger logger = LoggerFactory.getLogger(ByteArrayEncryptionStrategy.class);

    public ByteArrayEncryptionStrategy(byte[] aesKey) {
        super(aesKey);
    }

    @Override
    public byte[] encrypted(byte[] bytes) {
        super.check(bytes);
        byte[] ciphertext = AES.encryptIvCBC(bytes, aesKey);
        if (ciphertext.length > 0) {
            return ciphertext;
        }
        throw new DMCException("字节数组加密后为空!");
    }

}
