package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;

/**
 * 文件信息相关操作
 *
 * @author fobgochod
 * @date 2023/8/7 16:25
 */
public class FileInfoV1Operation extends DMCOperation {

    public FileInfoV1Operation(ServiceClient client) {
        super(client);
    }

    /**
     * 获取文件信息<br>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/info
     */
    public FileInfo getFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileInfoUrlV1(original.getBucket(), original.getFileId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    /**
     * 重命名文件<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/rename/{newFileName}
     */
    public void renameFile(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getRenameFileUrlV1(original.getBucket(), original.getFileId(), original.getFileName()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    /**
     * 复制文件<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/copyto/directory/{targetDirId}
     */
    public String copyFile(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileCopyUrlV1(original.getBucket(), original.getFileId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseV1Parsers.fileIdResponseParser);
    }

    /**
     * 移动文件<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/{fileId}/moveto/directory/{targetDirId}
     */
    public void moveFile(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileMoveUrlV1(original.getBucket(), original.getFileId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    /**
     * 批量复制文件<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/copy/batch/directory/{targetDirId}
     */
    public void copyFileBatch(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileCopyBatchUrlV1(original.getBucket(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }

    /**
     * 批量移动文件<br>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/files/move/batch/directory/{targetDirId}
     */
    public void moveFileBatch(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getFileMoveBatchUrlV1(original.getBucket(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        doOperation(request, ResponseParsers.emptyResponseParser);
    }
}


