package com.digiwin.dap.middleware.dmc.internal.model;

import com.digiwin.dap.middleware.dmc.event.ProgressListener;

public abstract class WebServiceRequest {

    public static final WebServiceRequest NOOP = new WebServiceRequest() {
    };

    private ProgressListener progressListener = ProgressListener.NOOP;

    public ProgressListener getProgressListener() {
        return progressListener;
    }

    public void setProgressListener(ProgressListener progressListener) {
        this.progressListener = (progressListener == null) ? ProgressListener.NOOP : progressListener;
    }

    public <T extends WebServiceRequest> T withProgressListener(ProgressListener progressListener) {
        setProgressListener(progressListener);
        @SuppressWarnings("unchecked")
        T t = (T) this;
        return t;
    }
}
