package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.model.BucketRequest;
import com.digiwin.dap.middleware.dmc.model.Bucket;
import com.digiwin.dmc.sdk.entity.BucketInfo;

public class DMCBucketOperation extends DMCOperation {
    public DMCBucketOperation(ServiceClient client) {
        super(client);
    }

    public Bucket getBucketInfoByName() {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getBucketInfoByNameUrl())
                .setMethod(HttpMethod.GET)
                .setForceRetry(true)
                .build();
        return doOperation(request, ResponseParsers.bucketResponseParser);
    }
}
