package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpTree;

import java.util.List;

/**
 * 复制
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class DMCCopyOperation extends DMCOperation {

    public DMCCopyOperation(ServiceClient client) {
        super(client);
    }

    public String copy(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getCopyUrl(original.getFileId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.copyResponseParser);
    }

    public String copyDir(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getCopyDirUrl(original.getDirId(), original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.copyDirResponseParser);
    }

    public List<FileOpTree> copyMulti(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getCopyMultiUrl(original.getTargetDirId()))
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .build();
        return doOperation(request, ResponseParsers.copyMultiResponseParser);
    }
}


