package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.security.RSAAESDecryptionDownloadResponse;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.BatchRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;


public class DMCDownloadEncryptionOperation extends DMCOperation {

    private final String publicKey;

    private final RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse;


    public DMCDownloadEncryptionOperation(ServiceClient client, String publicKey,
                                          RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse) {
        super(client);
        this.publicKey = publicKey;
        this.rsaaesDecryptionDownloadResponse = rsaaesDecryptionDownloadResponse;
    }

    public byte[] download(DownloadRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadUrl(original.getFileId()))
                .setMethod(HttpMethod.GET)
                .setHeaders(original.getHeaders())
                .setOriginalRequest(original)
                .setClientPublicKey(publicKey)
                .setDMCSecurity(Boolean.TRUE)
                .build();
        return rsaaesDecryptionDownloadResponse.decrypt(doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }

    public byte[] downloadMulti(BatchRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create()
                .setEndpoint(config.getDownloadMultiUrl())
                .setMethod(HttpMethod.POST)
                .setHeaders(original.getHeaders())
                .setEntity(original.getEntity())
                .setForceRetry(true)
                .setOriginalRequest(original)
                .setClientPublicKey(publicKey)
                .setDMCSecurity(Boolean.TRUE)
                .build();
        return rsaaesDecryptionDownloadResponse.decrypt(doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }
}


