package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

/**
 * 目录参数
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class DirRequest extends GenericRequest {

    private String dirId;
    private String dirName;
    private DirInfo dirInfo;

    public String getDirId() {
        return dirId;
    }

    public void setDirId(String dirId) {
        this.dirId = dirId;
    }

    public String getDirName() {
        return dirName;
    }

    public void setDirName(String dirName) {
        this.dirName = dirName;
    }

    public DirInfo getDirInfo() {
        return dirInfo;
    }

    public void setDirInfo(DirInfo dirInfo) {
        this.dirInfo = dirInfo;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(dirInfo))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
