package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

public class LoginRequest extends GenericRequest {

    private LoginUser loginUser;

    public LoginUser getLoginUser() {
        return loginUser;
    }

    public void setLoginUser(LoginUser loginUser) {
        this.loginUser = loginUser;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(loginUser))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
