package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

import java.io.File;
import java.io.InputStream;

/**
 * 上传参数
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class UploadRequest extends GenericRequest {

    protected File file;
    protected byte[] bytes;
    protected InputStream input;
    protected FileInfo fileInfo;
    protected String fileId;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @Override
    public HttpEntity build() {
        MultipartEntityBuilder builder = builder();
        if (fileInfo != null) {
            builder.addTextBody("fileInfo", JsonUtils.writeValue(fileInfo), ContentType.APPLICATION_JSON);
        }
        return builder.build();
    }

    protected MultipartEntityBuilder builder() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.RFC6532);
        if (file != null) {
            builder.addBinaryBody("file", file);
        } else if (bytes != null) {
            builder.addBinaryBody("file", bytes, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        } else if (input != null) {
            builder.addBinaryBody("file", input, ContentType.DEFAULT_BINARY, fileInfo.getFileName());
        }
        return builder;
    }
}
