package com.digiwin.dmc.sdk.entity;

import com.digiwin.dap.middleware.dmc.common.utils.DMCUtils;
import com.fasterxml.jackson.annotation.JsonProperty;

public class UserInfo {

    private String id;
    /**
     * 密码
     */
    @JsonProperty("pwdHash")
    private String password;
    /**
     * 用户登录名
     */

    private String name;
    /**
     * 用户显示名
     */

    private String displayName;
    /**
     * 用户角色
     */
    @JsonProperty("builtinRole")
    private UserRole role;

    public UserInfo(String userName, String password, String displayName, UserRole role) {
        this.password = DMCUtils.sha256(password);
        this.name = userName;
        this.displayName = displayName;
        this.role = role;
    }

    public UserInfo() {
    }

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getPassword() {
        return password;
    }

    public void setPassword(String password) {
        this.password = DMCUtils.sha256(password);
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDisplayName() {
        return displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public UserRole getRole() {
        return role;
    }

    public void setRole(UserRole role) {
        this.role = role;
    }

}
