package com.digiwin.dmc.sdk.service;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.identity.UserIdentity;

import java.util.List;

public interface IUserManagerService {

    /**
     * 创建用户
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/users
     *
     * @param userInfo 用户信息
     * @return id
     */
    String createUser(UserInfo userInfo);

    /**
     * 按照用户名查询用户
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/users/{name}
     *
     * @param userName 用户名
     * @return 用户信息
     */
    UserInfo getUser(String userName);

    /**
     * 查询所有用户
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/users
     *
     * @return 用户信息
     */
    List<UserInfo> getUsers();

    /**
     * 用户是否存在
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/users/{name}/isExist
     *
     * @param userName 用户名
     * @return true/false
     */
    String isExistUser(String userName);

    /**
     * 获取用户token
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/auth/login
     *
     * @param identity 用户信息
     * @return token
     */
    String getUserToken(UserIdentity identity);

}
