package com.digiwin.dmc.sdk.service.discard;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dmc.sdk.entity.Query.FileInfoQuery;
import com.digiwin.dmc.sdk.entity.Query.FullTextCondition;
import com.digiwin.dmc.sdk.entity.Query.QueryResult;

@Deprecated
public interface IFileInfoTextService extends IDocumentStorageServiceDiscard {

    /**
     * 根据FileInfoQuery查询文档
     * <p>
     * {@link HttpMethod#POST} - /api/dmc/v1/buckets/{bucket}/query
     *
     * @param bucketName 存储区
     * @param query      查询条件
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query, String driveToken);

    QueryResult queryFileInfoByFileInfoQuery(String bucketName, FileInfoQuery query);

    QueryResult queryFileInfoByFileInfoQuery(FileInfoQuery query);


    /**
     * 根据单个字段精确查询
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/query/fields/{field}/values/{value}/
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param value      字段值
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByField(String bucketName, String field, String value, String driveToken);

    QueryResult queryFileInfoByField(String bucketName, String field, String value);

    QueryResult queryFileInfoByField(String field, String value);


    /**
     * 根据单个字段精确查询
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/query/fields/{field}/values/{value}/{pageNum}/{pageSize}
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param value      字段值
     * @param pageNum    当前页
     * @param pageSize   显示个数
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize, String driveToken);

    QueryResult queryFileInfoByFieldWithPage(String bucketName, String field, String value, String pageNum, String pageSize);

    QueryResult queryFileInfoByFieldWithPage(String field, String value, String pageNum, String pageSize);


    /**
     * 单个字段比较查询
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/query/fields/{field}/operators/{operator}/values/{value}/{pageNum}/{pageSize}
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param operator   操作符
     * @param value      字段值
     * @param pageNum    当前页
     * @param pageSize   显示个数
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize, String driveToken);

    QueryResult queryFileInfoByOperatorWithPage(String bucketName, String field, String operator, String value, String pageNum, String pageSize);

    QueryResult queryFileInfoByOperatorWithPage(String field, String operator, String value, String pageNum, String pageSize);


    /**
     * 单个字段比较查询
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/api/dmc/v1/buckets/{bucket}/query/fields/{field}/operators/{operator}/values/{value}/
     *
     * @param bucketName 存储区
     * @param field      字段名
     * @param operator   操作符
     * @param value      字段值
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value, String driveToken);

    QueryResult queryFileInfoByOperator(String bucketName, String field, String operator, String value);

    QueryResult queryFileInfoByOperator(String field, String operator, String value);


    /**
     * 全文搜索，针对一个库
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/buckets/{bucket}/query/fulltext
     *
     * @param bucketName 存储区
     * @param search     搜索条件
     * @param driveToken driveToken
     * @return 查询结果
     */
    QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search, String driveToken);

    QueryResult queryFileInfoByFullText(String bucketName, FullTextCondition search);

    QueryResult queryFileInfoByFullText(FullTextCondition search);


    /**
     * 全文搜索，针对多个库
     * <p>
     * {@link HttpMethod#GET} - /api/dmc/v1/query/fulltext
     *
     * @param search      搜索条件
     * @param accessToken 操作Token
     * @return
     */
    QueryResult queryFileInfoByFullText(FullTextCondition search, String accessToken);
}
