package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.HttpUtils;

import java.util.Map;

public class FileService implements IFileService {

    private static volatile FileService fileService;

    /**
     * 单一实例 DCL
     */
    public static IFileService fileInstance() {
        if (fileService == null) {
            synchronized (FileService.class) {
                if (fileService == null) {
                    fileService = new FileService();
                }
            }
        }
        return fileService;
    }

    @Override
    public byte[] download(String fileId, TenantId... tenantId) {
        return this.download(null, null, fileId, null, tenantId);
    }

    @Override
    public byte[] download(String bucketName, String fileId, TenantId... tenantId) {
        return this.download(null, bucketName, fileId, null, tenantId);
    }

    @Deprecated
    @Override
    public byte[] download(String discardTenantId, String bucketName, String fileId, TenantId... tenantId) {
        return this.download(discardTenantId, bucketName, fileId, null, tenantId);
    }

    @Deprecated
    @Override
    public byte[] download(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId... tenantId) {
        ArgumentUtils.download(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, tenantId);
        DownloadRequest request = new DownloadRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        return ServerSetting.internal().downloadV1(request);
    }
}
