package com.digiwin.dmc.sdk.util;

import java.util.concurrent.*;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * Static utility methods for manipulating an {@link ExecutorService}.
 *
 * @author fobgochod
 * @date 2022/6/7 17:39
 */
public class ExecutorUtil {

    public static final ThreadFactory THREAD_FACTORY = new ThreadFactory() {

        private final ThreadFactory defaultFactory = Executors.defaultThreadFactory();
        private final AtomicInteger threadNumber = new AtomicInteger(1);

        public Thread newThread(Runnable r) {
            Thread thread = defaultFactory.newThread(r);
            if (!thread.isDaemon()) {
                thread.setDaemon(true);
            }
            thread.setName("dmc-sdk-" + threadNumber.getAndIncrement());
            return thread;
        }
    };
    private static final int CORE_POOL_SIZE = 0;
    private static final int MAX_POOL_SIZE = 10;
    private static ExecutorService executorService;

    /**
     * Creates an executor service suitable for use by logback components.
     *
     * @return executor service
     */
    public static ExecutorService newExecutor() {
        if (executorService == null) {
            executorService = new ThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 0L, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), THREAD_FACTORY);
        }
        return executorService;
    }

    /**
     * Shuts down an executor service.
     * <p>
     *
     * @param executorService the executor service to shut down
     */
    public static void shutdown(ExecutorService executorService) {
        executorService.shutdownNow();
    }
}
