package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCLogin;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;

/**
 * Provides access to credentials used for accessing DMC, these credentials are
 * used to securely sign requests to DMC.
 *
 * @author fobgochod
 * @date 2021/4/20
 */
public class AuthCache {

    private DMCLoginOperation loginOperation;

    public void setLoginOperation(DMCLoginOperation loginOperation) {
        this.loginOperation = loginOperation;
    }

    public String getToken(DMCConfig config) {
        return getToken(config, config.getTenantId());
    }

    public String getToken(DMCConfig config, String tenantId) {
        return getToken(config.getUsername(), config.getPwdhash(), tenantId);
    }

    /**
     * 获取DMC userToken并缓存
     *
     * @param username 用户名
     * @param pwdhash  密码
     * @param tenantId 租户
     * @return userToken
     */
    public synchronized String getToken(String username, String pwdhash, String tenantId) {
        try {
            String uniqueKey = DMCLogin.uniqueKey(username, tenantId);
            // 优先获取缓存userToken
            String userToken = TokenCache.get(uniqueKey);
            if (userToken != null) {
                return userToken;
            }
            // 没有缓存，重新登录获取
            TokenCache.put(uniqueKey, loginOperation.login(username, pwdhash, tenantId));
            return TokenCache.get(uniqueKey);
        } catch (Exception e) {
            throw new InvalidTokenException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("LoginError", username), e);
        }
    }
}
