package com.digiwin.dap.middleware.dmc.common.comm;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.HttpStatus;
import org.apache.http.protocol.HttpContext;

import java.io.IOException;

public class CustomHttpResponseInterceptor implements HttpResponseInterceptor {

    public static final CustomHttpResponseInterceptor INSTANCE = new CustomHttpResponseInterceptor();

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        int status = response.getStatusLine().getStatusCode();
        if (status == HttpStatus.SC_BAD_GATEWAY || status == HttpStatus.SC_SERVICE_UNAVAILABLE) {
            // 符合重试的状态码，抛出IOException进行重试
            throw new CustomStatusRetryException(response.getStatusLine());
        }
    }
}
