package com.digiwin.dap.middleware.dmc.common.comm;

import com.digiwin.dap.middleware.dmc.ClientException;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.utils.HttpHeaders;
import com.digiwin.dap.middleware.dmc.event.ProgressInputStream;
import com.digiwin.dap.middleware.dmc.event.ProgressListener;
import com.digiwin.dap.middleware.dmc.event.ProgressPublisher;
import com.digiwin.dap.middleware.dmc.internal.model.WebServiceRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.InputStream;
import java.util.Map;

public class ResponseProgressHandler implements ResponseHandler {

    private static final Logger logger = LoggerFactory.getLogger(ResponseProgressHandler.class);

    private final WebServiceRequest originalRequest;

    public ResponseProgressHandler(WebServiceRequest originalRequest) {
        this.originalRequest = originalRequest;
    }

    @Override
    public void handle(ResponseMessage response) throws DMCException, ClientException {

        final ProgressListener listener = this.originalRequest.getProgressListener();
        Map<String, String> headers = response.getHeaders();
        String s = headers.get(HttpHeaders.CONTENT_LENGTH);
        if (s != null) {
            try {
                long contentLength = Long.parseLong(s);
                ProgressPublisher.publishResponseContentLength(listener, contentLength);
            } catch (NumberFormatException e) {
                logger.error("Cannot parse the Content-Length header of the response: ", e);
            }
        }

        InputStream content = response.getContent();
        if (content != null && listener != ProgressListener.NOOP) {
            InputStream progressInputStream = ProgressInputStream.inputStreamForResponse(content, originalRequest);
            response.setContent(progressInputStream);
        }
    }
}
