package com.digiwin.dap.middleware.dmc.common.context;

import com.digiwin.dap.middleware.dmc.model.IamUserToken;

/**
 * @author
 * @date 2025/9/5
 */
public final class IamUserTokenHolder {

    private static final ThreadLocal<IamUserToken> contextHolder = new ThreadLocal<>();

    IamUserTokenHolder() {
    }

    /**
     * 请空当前线程数据
     */
    public static void clearContext() {
        contextHolder.remove();
    }

    /**
     * 获取当前Iam User Token数据
     */
    public static IamUserToken getContext() {
        return contextHolder.get();
    }

    /**
     * 设置当前Iam User Token数据
     */
    public static void setContext(IamUserToken context) {
        contextHolder.set(context);
    }
}
