package com.digiwin.dap.middleware.dmc.common.security;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.internal.DMCHeaders;
import com.digiwin.dap.middleware.dmc.model.DownloadSecurity;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;

public class RSAAESDecryptionDownloadResponse extends DecryptionDownloadResponse {

    protected static final Logger logger = LoggerFactory.getLogger(RSAAESDecryptionDownloadResponse.class);

    public RSAAESDecryptionDownloadResponse(String privateKey) {
        super(privateKey);
    }

    @Override
    public byte[] decrypt(DownloadSecurity downloadSecurity) throws IOException {
        if (Objects.isNull(downloadSecurity)) {
            throw new DMCException("response为空!");
        }
        Map<String, String> header = downloadSecurity.getHeaders();
        if (Objects.isNull(header)) {
            throw new DMCException("response header为空!");
        }
        boolean dmcSecurity = Boolean.parseBoolean(header.getOrDefault(DMCHeaders.DMC_SECURITY, "false"));
        String digitalEnvelope = header.get(DMCHeaders.DIGITAL_ENVELOPE);
        if (!dmcSecurity) {
            logger.warn("下载不需要解密!");
            return downloadSecurity.getBytes();
        }
        if (digitalEnvelope == null || digitalEnvelope.isEmpty()) {
            throw new DMCException("数字信封为空!");
        }
        byte[] aseKey = RSA.decryptOAEP(Base64.decode(digitalEnvelope), super.privateKey);
        return AES.decryptIvCBC(downloadSecurity.getBytes(), aseKey);
    }

}


