package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;

import java.io.File;

/**
 * 图片处理
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class ImageRequest extends GenericRequest {

    private File file;
    private FileInfo fileInfo;
    private String fileId;
    private Boolean shrink = Boolean.TRUE;
    private Integer width;
    private Integer height;
    private Boolean share = Boolean.TRUE;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public String getFileId() {
        return fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    public Boolean getShrink() {
        return shrink;
    }

    public void setShrink(Boolean shrink) {
        this.shrink = shrink;
    }

    public Integer getWidth() {
        return width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public Integer getHeight() {
        return height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public Boolean getShare() {
        return share;
    }

    public void setShare(Boolean share) {
        this.share = share;
    }

    @Override
    public HttpEntity build() {
        return EntityBuilder.create().setFile(file).build();
    }
}
