package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.DMCConstants;
import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;

import java.io.File;
import java.io.InputStream;

/**
 * 分段上传参数
 *
 * @author fobgochod
 * @since 3.1.0.0
 */
public class MultipartUploadRequest extends GenericRequest {

    private File file;
    private byte[] bytes;
    private InputStream input;
    private FileInfo fileInfo;

    private long fileLength;
    private long partSize = DMCConstants.DEFAULT_PART_SIZE;

    public File getFile() {
        return file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public FileInfo getFileInfo() {
        return fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public long getFileLength() {
        return fileLength;
    }

    public void setFileLength(long fileLength) {
        this.fileLength = fileLength;
    }

    public long getPartSize() {
        return partSize;
    }

    public void setPartSize(long partSize) {
        this.partSize = partSize;
    }
}
