package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.util.JsonUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.EntityBuilder;
import org.apache.http.entity.ContentType;

import java.util.HashMap;
import java.util.Map;

/**
 * @author geyao
 * @date 2025/9/8
 */
public class UserAppRequest extends GenericRequest {

    private String appId;

    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Override
    public HttpEntity build() {
        Map<String, Object> map = new HashMap<>(1);
        map.put("appId", appId);
        return EntityBuilder.create()
                .setText(JsonUtils.writeValue(map))
                .setContentType(ContentType.APPLICATION_JSON).build();
    }
}
