package com.digiwin.dmc.sdk.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * DriveAuthRequestAction
 *
 * @author chenxsa
 * @date 2018-6-6 14:32
 */
public class DriveAuthRequest implements Serializable {

    private List<DriveAuthItem> items;

    public DriveAuthRequest() {
        items = new ArrayList<>();
    }

    public List<DriveAuthItem> getItems() {
        return items;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DriveAuthRequest) {
            DriveAuthRequest item = (DriveAuthRequest) obj;
            if (item.items.size() != this.items.size()) {
                return false;
            }
            for (int i = 0; i < this.items.size(); i++) {
                if (!this.items.get(i).equals(item.items.get(i))) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int hash = 0;
        for (DriveAuthItem item : this.items) {
            hash = hash ^ item.hashCode();
        }
        return hash;
    }
}
