/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.ClientConfiguration;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCClient;
import com.digiwin.dap.middleware.dmc.DMCEncryptionClient;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;

public class DMCEncryptionClientBuilder {
    private final boolean lazy;

    public DMCEncryptionClientBuilder(boolean lazy) {
        this.lazy = lazy;
    }

    public static DMCEncryptionClientBuilder create() {
        return new DMCEncryptionClientBuilder(true);
    }

    public DMC build() {
        DMCConfig config = DMCConfigBuilder.create().lazy(this.lazy).build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).lazy(this.lazy).build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).appToken(appToken).appSecret(appSecret).lazy(this.lazy).build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String tenantId, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).tenantId(tenantId).lazy(this.lazy).build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(String uri, String username, String password, String tenantId, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).appToken(appToken).appSecret(appSecret).tenantId(tenantId).lazy(this.lazy).build();
        return new DMCEncryptionClient(config);
    }

    public DMC build(DMCConfig config) {
        return new DMCEncryptionClient(config);
    }

    public DMC build(DMCConfig config, ClientConfiguration clientConfig) {
        return new DMCClient(config, clientConfig);
    }
}

