/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.auth;

import com.digiwin.dap.middleware.dmc.common.auth.InvalidTokenException;
import com.digiwin.dap.middleware.dmc.common.auth.TokenCache;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCLogin;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.operation.DMCLoginOperation;

public class AuthCache {
    private DMCLoginOperation loginOperation;

    public void setLoginOperation(DMCLoginOperation loginOperation) {
        this.loginOperation = loginOperation;
    }

    public String getToken(DMCConfig config) {
        return this.getToken(config, config.getTenantId());
    }

    public String getToken(DMCConfig config, String tenantId) {
        return this.getToken(config.getUsername(), config.getPwdhash(), tenantId);
    }

    public synchronized String getToken(String username, String pwdhash, String tenantId) {
        try {
            String uniqueKey = DMCLogin.uniqueKey(username, tenantId);
            String userToken = TokenCache.get(uniqueKey);
            if (userToken != null) {
                return userToken;
            }
            TokenCache.put(uniqueKey, this.loginOperation.login(username, pwdhash, tenantId));
            return TokenCache.get(uniqueKey);
        }
        catch (Exception e) {
            throw new InvalidTokenException(DMCUtils.DMC_RESOURCE_MANAGER.getFormattedString("LoginError", username), e);
        }
    }
}

