/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.security;

import com.digiwin.dap.middleware.commons.core.codec.Base64;
import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.commons.crypto.RSA;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.security.DecryptionDownloadResponse;
import com.digiwin.dap.middleware.dmc.model.DownloadSecurity;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSAAESDecryptionDownloadResponse
extends DecryptionDownloadResponse {
    protected static final Logger logger = LoggerFactory.getLogger(RSAAESDecryptionDownloadResponse.class);

    public RSAAESDecryptionDownloadResponse(String privateKey) {
        super(privateKey);
    }

    @Override
    public byte[] decrypt(DownloadSecurity downloadSecurity) throws IOException {
        if (Objects.isNull(downloadSecurity)) {
            throw new DMCException("response\u4e3a\u7a7a!");
        }
        Map<String, String> header = downloadSecurity.getHeaders();
        if (Objects.isNull(header)) {
            throw new DMCException("response header\u4e3a\u7a7a!");
        }
        boolean dmcSecurity = Boolean.parseBoolean(header.getOrDefault("digi-middleware-security", "false"));
        String digitalEnvelope = header.get("digi-middleware-digital-envelope");
        if (!dmcSecurity) {
            logger.warn("\u4e0b\u8f7d\u4e0d\u9700\u8981\u89e3\u5bc6!");
            return downloadSecurity.getBytes();
        }
        if (digitalEnvelope == null || digitalEnvelope.isEmpty()) {
            throw new DMCException("\u6570\u5b57\u4fe1\u5c01\u4e3a\u7a7a!");
        }
        byte[] aseKey = RSA.decryptOAEP((byte[])Base64.decode((String)digitalEnvelope), (String)this.privateKey);
        return AES.decryptIvCBC((byte[])downloadSecurity.getBytes(), (byte[])aseKey);
    }
}

