/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.ByteArrayEncryptionStrategy;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.FileEncryptionStrategy;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.InputStreamEncryptionStrategy;
import java.io.File;
import java.io.InputStream;
import java.util.Objects;

public class EncryptionStrategyFactory {
    protected final byte[] key;

    public EncryptionStrategyFactory(byte[] key) {
        this.key = key;
    }

    public <T> T strategy(T t) {
        if (Objects.isNull(t)) {
            return null;
        }
        if (t instanceof File) {
            return (T)new FileEncryptionStrategy(this.key).encrypted((File)t);
        }
        if (t instanceof byte[]) {
            return (T)new ByteArrayEncryptionStrategy(this.key).encrypted((byte[])t);
        }
        if (t instanceof InputStream) {
            return (T)new InputStreamEncryptionStrategy(this.key).encrypted((InputStream)t);
        }
        throw new DMCException("strategy not found!");
    }
}

