/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.security.encryption.strategy;

import com.digiwin.dap.middleware.commons.crypto.AES;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.AbstractEncryptionStrategy;
import com.digiwin.dap.middleware.dmc.common.utils.FileUtils;
import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEncryptionStrategy
extends AbstractEncryptionStrategy<File> {
    protected static final Logger logger = LoggerFactory.getLogger(FileEncryptionStrategy.class);

    public FileEncryptionStrategy(byte[] aesKey) {
        super(aesKey);
    }

    @Override
    public File encrypted(File file) {
        super.check(file);
        byte[] ciphertext = AES.encryptIvCBC((byte[])FileUtils.readFileToByteArray(file), (byte[])this.aesKey);
        if (ciphertext.length > 0) {
            return FileUtils.writeByteArrayToFile(ciphertext, file.getName());
        }
        throw new DMCException("\u6587\u4ef6\u52a0\u5bc6\u4e3a\u7a7a!");
    }
}

