/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.utils;

public abstract class Assert {
    public static void state(boolean expression, String message) {
        if (!expression) {
            throw new IllegalStateException(message);
        }
    }

    public static void isTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void isNull(Object object, String message) {
        if (object != null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void notNull(Object object, String message) {
        if (object == null) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasLength(String text, String message) {
        if (!Assert.hasLength(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void hasText(String text, String message) {
        if (!Assert.hasText(text)) {
            throw new IllegalArgumentException(message);
        }
    }

    private static boolean hasLength(String str) {
        return str != null && !str.isEmpty();
    }

    private static boolean hasText(String str) {
        return str != null && !str.isEmpty() && Assert.containsText(str);
    }

    private static boolean containsText(CharSequence str) {
        int strLen = str.length();
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

