/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.common.utils;

import com.auth0.jwt.JWT;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.digiwin.dap.middleware.dmc.DMCException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.apache.commons.codec.binary.Base64;

public class DMCUtils {
    private static final List<String> ROOT_DIR = new ArrayList<String>(){
        {
            this.add("0");
            this.add(null);
            this.add("null");
            this.add("00000000-0000-0000-0000-000000000000");
        }
    };

    private static boolean isRootDir(String dirId) {
        return ROOT_DIR.contains(dirId);
    }

    public static String getDirId(String dirId) {
        if (DMCUtils.isRootDir(dirId)) {
            return "00000000-0000-0000-0000-000000000000";
        }
        return dirId;
    }

    public static boolean isExpires(String token) {
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            Calendar cal = Calendar.getInstance();
            cal.setTime(new Date());
            cal.add(13, 30);
            return cal.getTime().after(jwt.getExpiresAt());
        }
        catch (Exception exception) {
            return true;
        }
    }

    public static String sha256(String data) {
        String encodeStr;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(data.getBytes(StandardCharsets.UTF_8));
            byte[] bytes = messageDigest.digest();
            messageDigest.update(bytes);
            encodeStr = Base64.encodeBase64String((byte[])messageDigest.digest());
        }
        catch (Exception e) {
            throw new DMCException(String.format("[%s]\u52a0\u5bc6\u9519\u8bef\uff1a%s", data, e.getMessage()));
        }
        return encodeStr;
    }
}

