/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.common.utils.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.LoadServerSetting;
import java.util.List;

public final class DMCConfigBuilder {
    private String uri;
    private String bucket;
    private String username;
    private String password;
    private String tenantId;
    private boolean lazy;
    private String appToken;
    private String appSecret;
    private List<String> appIds;

    private DMCConfigBuilder() {
    }

    public static DMCConfigBuilder create() {
        DMCConfigBuilder configBuilder = new DMCConfigBuilder();
        LoadServerSetting.loadDefault(configBuilder);
        return configBuilder;
    }

    public static DMCConfigBuilder create(String uri, String username, String password, String bucket) {
        return new DMCConfigBuilder().uri(uri).username(username).password(password).bucket(bucket);
    }

    public DMCConfigBuilder uri(String uri) {
        this.uri = uri;
        return this;
    }

    public DMCConfigBuilder bucket(String bucket) {
        this.bucket = bucket;
        return this;
    }

    public DMCConfigBuilder username(String username) {
        this.username = username;
        return this;
    }

    public DMCConfigBuilder password(String password) {
        this.password = password;
        return this;
    }

    public DMCConfigBuilder tenantId(String tenantId) {
        this.tenantId = tenantId;
        return this;
    }

    public DMCConfigBuilder lazy(boolean lazy) {
        this.lazy = lazy;
        return this;
    }

    public DMCConfigBuilder appToken(String appToken) {
        this.appToken = appToken;
        return this;
    }

    public DMCConfigBuilder appSecret(String appSecret) {
        this.appSecret = appSecret;
        return this;
    }

    public DMCConfigBuilder appIds(List<String> appIds) {
        this.appIds = appIds;
        return this;
    }

    public DMCConfig build() {
        DMCConfig config = new DMCConfig();
        config.setUri(this.uri);
        config.setBucket(this.bucket);
        config.setUsername(this.username);
        config.setPassword(this.password);
        if (this.password != null) {
            config.setPwdhash(DMCUtils.sha256(this.password));
        }
        config.setTenantId(this.tenantId);
        config.setLazy(this.lazy);
        config.setAppToken(this.appToken);
        config.setAppSecret(this.appSecret);
        config.setAppIds(this.appIds);
        return config;
    }
}

