/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal;

import com.digiwin.dap.middleware.dmc.ClientException;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseHandler;
import com.digiwin.dap.middleware.dmc.common.comm.ResponseMessage;
import com.digiwin.dap.middleware.dmc.common.parser.ErrorResponseParser;
import com.digiwin.dap.middleware.dmc.common.parser.ResponseParseException;
import com.digiwin.dap.middleware.dmc.common.utils.ExceptionFactory;
import com.digiwin.dap.middleware.dmc.internal.DMCUtils;
import com.digiwin.dap.middleware.dmc.internal.model.StdError;

public class ErrorResponseHandler
implements ResponseHandler {
    @Override
    public void handle(ResponseMessage response) throws DMCException, ClientException {
        if (response.isSuccessful()) {
            return;
        }
        String requestId = response.getRequestId();
        int statusCode = response.getStatusCode();
        if (response.getContent() == null) {
            if (statusCode == 404) {
                throw ExceptionFactory.createDMCException(requestId, "NoSuchKey", "Not Found");
            }
            if (statusCode == 304) {
                throw ExceptionFactory.createDMCException(requestId, "NotModified", "Not Modified");
            }
            if (statusCode == 412) {
                throw ExceptionFactory.createDMCException(requestId, "PreconditionFailed", "Precondition Failed");
            }
            if (statusCode == 403) {
                throw ExceptionFactory.createDMCException(requestId, "AccessForbidden", "AccessForbidden");
            }
            throw ExceptionFactory.createUnknownDMCException(requestId, statusCode);
        }
        try {
            try {
                ErrorResponseParser parser = new ErrorResponseParser();
                StdError stdError = parser.parse(response);
                throw ExceptionFactory.createDMCException(stdError);
            }
            catch (ResponseParseException e) {
                throw ExceptionFactory.createInvalidResponseException(requestId, response.getError(), e);
            }
        }
        catch (Throwable throwable) {
            DMCUtils.safeCloseResponse(response);
            throw throwable;
        }
    }
}

