/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;
import com.digiwin.dap.middleware.dmc.model.DirInfo;
import com.digiwin.dap.middleware.dmc.model.DirRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;
import com.digiwin.dap.middleware.dmc.model.FolderInfo;

public class DirInfoV1Operation
extends DMCOperation {
    public DirInfoV1Operation(ServiceClient client) {
        super(client);
    }

    public String createDir(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getCreateDirUrlV1(original.getBucket())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setForceRetry(true).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.dirIdResponseParser);
    }

    public void renameDir(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getRenameDirUrlV1(original.getBucket(), original.getDirId(), original.getDirName())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public DirInfo getDirInfo(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoUrlV1(original.getBucket(), original.getDirId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.dirInfoResponseParser);
    }

    public DirInfo getDirInfoByName(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirInfoGetByNameUrlV1(original.getDirInfo().getParentId(), original.getDirInfo().getName())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseParsers.dirInfoResponseParser);
    }

    public FolderInfo getDirContent(DirRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirContentUrlV1(original.getBucket(), original.getDirId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.dirContentResponseParser);
    }

    public String copyDir(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirCopyUrlV1(original.getBucket(), original.getDirId(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.dirIdResponseParser);
    }

    public void moveDir(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDirMoveUrlV1(original.getBucket(), original.getDirId(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }
}

