/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.security.RSAAESDecryptionDownloadResponse;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.DownloadPartRequest;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;

public class DownloadV1EncryptionOperation
extends DMCOperation {
    private final String publicKey;
    private final RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse;

    public DownloadV1EncryptionOperation(ServiceClient client, String publicKey, RSAAESDecryptionDownloadResponse rsaaesDecryptionDownloadResponse) {
        super(client);
        this.publicKey = publicKey;
        this.rsaaesDecryptionDownloadResponse = rsaaesDecryptionDownloadResponse;
    }

    public byte[] download(DownloadRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDownloadUrlV1(original.getBucket(), original.getFileId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).setDMCSecurity(Boolean.TRUE).setClientPublicKey(this.publicKey).build();
        return this.rsaaesDecryptionDownloadResponse.decrypt(this.doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }

    public byte[] downloadPart(DownloadPartRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getDownloadPartUrlV1(original.getBucket(), original.getFileId(), original.getPosition(), original.getLength())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).setClientPublicKey(this.publicKey).build();
        return this.rsaaesDecryptionDownloadResponse.decrypt(this.doOperation(request, ResponseParsers.downloadSecurityResponseParser));
    }
}

