/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.client.operation;

import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.internal.client.parser.ResponseV1Parsers;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.FileOpRequest;

public class FileInfoV1Operation
extends DMCOperation {
    public FileInfoV1Operation(ServiceClient client) {
        super(client);
    }

    public FileInfo getFileInfo(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileInfoUrlV1(original.getBucket(), original.getFileId())).setMethod(HttpMethod.GET).setHeaders(original.getHeaders()).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.fileInfoResponseParser);
    }

    public void renameFile(FileInfoRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getRenameFileUrlV1(original.getBucket(), original.getFileId(), original.getFileName())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public String copyFile(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileCopyUrlV1(original.getBucket(), original.getFileId(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        return this.doOperation(request, ResponseV1Parsers.fileIdResponseParser);
    }

    public void moveFile(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileMoveUrlV1(original.getBucket(), original.getFileId(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void copyFileBatch(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileCopyBatchUrlV1(original.getBucket(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }

    public void moveFileBatch(FileOpRequest original) throws Exception {
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getFileMoveBatchUrlV1(original.getBucket(), original.getTargetDirId())).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setForceRetry(true).setOriginalRequest(original).build();
        this.doOperation(request, ResponseParsers.emptyResponseParser);
    }
}

