/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.internal.operation;

import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.HttpMethod;
import com.digiwin.dap.middleware.dmc.common.comm.RequestMessage;
import com.digiwin.dap.middleware.dmc.common.comm.ServiceClient;
import com.digiwin.dap.middleware.dmc.common.security.DigitalEnvelopeBuilder;
import com.digiwin.dap.middleware.dmc.common.security.encryption.strategy.EncryptionStrategyFactory;
import com.digiwin.dap.middleware.dmc.event.ProgressEventType;
import com.digiwin.dap.middleware.dmc.event.ProgressListener;
import com.digiwin.dap.middleware.dmc.event.ProgressPublisher;
import com.digiwin.dap.middleware.dmc.internal.DMCOperation;
import com.digiwin.dap.middleware.dmc.internal.DMCRequestMessageBuilder;
import com.digiwin.dap.middleware.dmc.internal.ResponseParsers;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.dmc.model.FileInfoRequest;
import com.digiwin.dap.middleware.dmc.model.MultipartUploadRequest;
import com.digiwin.dap.middleware.dmc.model.PartUploader;
import com.digiwin.dap.middleware.dmc.model.UploadCoverRequest;
import com.digiwin.dap.middleware.dmc.model.UploadMultiRequest;
import com.digiwin.dap.middleware.dmc.model.UploadRequest;
import java.io.File;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class DMCUploadEncryptionOperation
extends DMCOperation {
    private final DigitalEnvelopeBuilder digitalEnvelopeBuilder;
    private final EncryptionStrategyFactory encryptionStrategyFactory;

    public DMCUploadEncryptionOperation(ServiceClient client, EncryptionStrategyFactory encryptionStrategyFactory, DigitalEnvelopeBuilder digitalEnvelopeBuilder) {
        super(client);
        this.encryptionStrategyFactory = encryptionStrategyFactory;
        this.digitalEnvelopeBuilder = digitalEnvelopeBuilder;
    }

    public FileInfo upload(UploadRequest original) throws Exception {
        original.setBytes(this.encryptionStrategyFactory.strategy(original.getBytes()));
        original.setFile(this.encryptionStrategyFactory.strategy(original.getFile()));
        original.setInput(this.encryptionStrategyFactory.strategy(original.getInput()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        FileInfo fileInfo = this.doOperation(request, ResponseParsers.uploadResponseParser, true);
        this.deleteTempFile(original.getFile());
        return fileInfo;
    }

    public FileInfo coverUpload(UploadCoverRequest original) throws Exception {
        original.setBytes(this.encryptionStrategyFactory.strategy(original.getBytes()));
        original.setFile(this.encryptionStrategyFactory.strategy(original.getFile()));
        original.setInput(this.encryptionStrategyFactory.strategy(original.getInput()));
        RequestMessage request = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadCoverUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        FileInfo fileInfo = this.doOperation(request, ResponseParsers.uploadResponseParser, true);
        this.deleteTempFile(original.getFile());
        return fileInfo;
    }

    public List<FileInfo> uploadMulti(UploadMultiRequest original) throws Exception {
        ArrayList<File> encryptionFileList = new ArrayList<File>();
        for (File file : original.getFiles()) {
            encryptionFileList.add(this.encryptionStrategyFactory.strategy(file));
        }
        ArrayList<byte[]> encryptionByteList = new ArrayList<byte[]>();
        for (byte[] byArray : original.getBytes()) {
            encryptionByteList.add(this.encryptionStrategyFactory.strategy(byArray));
        }
        ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
        for (InputStream inputStream : original.getInputs()) {
            arrayList.add(this.encryptionStrategyFactory.strategy(inputStream));
        }
        original.setInputs(arrayList);
        original.setBytes(encryptionByteList);
        original.setFiles(encryptionFileList);
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadMultiUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setInputSize(original.getEntity().getContentLength()).setForceRetry(true).setOriginalRequest(original).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        List<FileInfo> fileInfoList = this.doOperation(requestMessage, ResponseParsers.uploadMultiResponseParser);
        for (File file : original.getFiles()) {
            this.deleteTempFile(file);
        }
        return fileInfoList;
    }

    public String multipartUpload(MultipartUploadRequest request) throws Exception {
        ProgressListener listener;
        String fileId;
        block34: {
            long partSize = request.getPartSize();
            if (partSize % 261120L != 0L) {
                throw new DMCException("\u5206\u6bb5\u5927\u5c0f\u8bf7\u8bbe\u7f6e261120\u7684\u6574\u6570\u500d");
            }
            fileId = this.claimFileId(request.getFileInfo());
            logger.info("Claiming a new file id {}.", (Object)fileId);
            long fileLength = request.getFileLength();
            int partCount = (int)(fileLength / partSize);
            if (fileLength % partSize != 0L) {
                ++partCount;
            }
            if (partCount > 10000) {
                throw new DMCException("\u5206\u6bb5\u603b\u6570\u4e0d\u80fd\u8d85\u8fc710000");
            }
            logger.info("Total parts count {}.", (Object)partCount);
            listener = request.getProgressListener();
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            ProgressPublisher.publishRequestContentLength(listener, fileLength);
            if (request.getInput() != null) {
                try (InputStream inputStream = request.getInput();){
                    for (int i = 0; i < partCount; ++i) {
                        long startPos = (long)i * partSize;
                        int curPartSize = (int)(i + 1 == partCount ? fileLength - startPos : partSize);
                        byte[] buffer = new byte[curPartSize];
                        inputStream.read(buffer);
                        this.uploadPart(fileId, buffer, startPos, curPartSize, fileLength, partCount, i + 1, listener, request.getPublicKey());
                    }
                    break block34;
                }
                catch (Exception e) {
                    ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                    throw e;
                }
            }
            try (RandomAccessFile raf = new RandomAccessFile(request.getFile(), "r");){
                MappedByteBuffer map = raf.getChannel().map(FileChannel.MapMode.READ_ONLY, 0L, fileLength);
                for (int i = 0; i < partCount; ++i) {
                    long startPos = (long)i * partSize;
                    int curPartSize = (int)(i + 1 == partCount ? fileLength - startPos : partSize);
                    byte[] buffer = new byte[curPartSize];
                    map.get(buffer, 0, curPartSize);
                    this.uploadPart(fileId, buffer, startPos, curPartSize, fileLength, partCount, i + 1, listener, request.getPublicKey());
                }
            }
            catch (Exception e) {
                ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
                throw e;
            }
        }
        ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        return fileId;
    }

    private void uploadPart(String fileId, byte[] buffer, long startPos, int curPartSize, long fileLength, int partCount, int partNum, ProgressListener listener, String publicKey) throws Exception {
        PartUploader partUploader = new PartUploader();
        partUploader.setFileId(fileId);
        partUploader.setParts(buffer);
        partUploader.setFrom(startPos);
        partUploader.setTo(startPos + (long)curPartSize - 1L);
        partUploader.setTotal(fileLength);
        partUploader.setPublicKey(publicKey);
        partUploader.setPartCount(partCount);
        partUploader.setPartNum(partNum);
        this.uploadPart(partUploader);
        ProgressPublisher.publishRequestBytesTransferred(listener, curPartSize);
        logger.info("\u603b\u5171\uff1a{}\u6bb5, \u7b2c{}\u6bb5\u4e0a\u4f20\u6210\u529f\uff1afileId={},startPos={},curPartSize={}.", new Object[]{partCount, partNum, fileId, startPos, curPartSize});
    }

    private void uploadPart(PartUploader original) throws Exception {
        byte[] ciphertext = this.encryptionStrategyFactory.strategy(original.getParts());
        original.setParts(ciphertext);
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadMultipartUrl(original.getFileId(), original.getFrom(), original.getTo(), original.getTotal(), original.getPartNum())).setMethod(HttpMethod.POST).setEntity(original.getEntity()).setForceRetry(true).setDigitalEnvelope(this.digitalEnvelopeBuilder.digitalEnvelope(original.getPublicKey())).setDMCSecurity(Boolean.TRUE).build();
        this.doOperation(requestMessage, ResponseParsers.uploadMultipartResponseParser);
    }

    private String claimFileId(FileInfo fileInfo) throws Exception {
        FileInfoRequest original = new FileInfoRequest();
        original.setFileInfo(fileInfo);
        RequestMessage requestMessage = DMCRequestMessageBuilder.create().setEndpoint(this.config.getUploadEmptyUrl()).setMethod(HttpMethod.POST).setHeaders(original.getHeaders()).setEntity(original.getEntity()).setForceRetry(true).setOriginalRequest(original).build();
        return this.doOperation(requestMessage, ResponseParsers.uploadMultipartResponseParser);
    }

    private void deleteTempFile(File file) {
        if (Objects.nonNull(file) && file.exists()) {
            file.delete();
            logger.info("\u4e34\u65f6\u6587\u4ef6\u5220\u9664\u6210\u529f!");
        }
    }
}

