/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc.model;

import com.digiwin.dap.middleware.dmc.internal.model.GenericRequest;
import com.digiwin.dap.middleware.dmc.model.FileInfo;
import com.digiwin.dap.middleware.util.JsonUtils;
import java.io.File;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;

public class UploadRequest
extends GenericRequest {
    protected File file;
    protected byte[] bytes;
    protected InputStream input;
    protected FileInfo fileInfo;
    protected String fileId;

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public InputStream getInput() {
        return this.input;
    }

    public void setInput(InputStream input) {
        this.input = input;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public void setFileInfo(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
    }

    public String getFileId() {
        return this.fileId;
    }

    public void setFileId(String fileId) {
        this.fileId = fileId;
    }

    @Override
    public HttpEntity build() {
        MultipartEntityBuilder builder = this.builder();
        if (this.fileInfo != null) {
            builder.addTextBody("fileInfo", JsonUtils.writeValue((Object)this.fileInfo), ContentType.APPLICATION_JSON);
        }
        return builder.build();
    }

    protected MultipartEntityBuilder builder() {
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        builder.setMode(HttpMultipartMode.RFC6532);
        if (this.file != null) {
            builder.addBinaryBody("file", this.file);
        } else if (this.bytes != null) {
            builder.addBinaryBody("file", this.bytes, ContentType.DEFAULT_BINARY, this.fileInfo.getFileName());
        } else if (this.input != null) {
            builder.addBinaryBody("file", this.input, ContentType.DEFAULT_BINARY, this.fileInfo.getFileName());
        }
        return builder;
    }
}

