/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.config;

import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.digiwin.dap.middleware.dmc.DMCException;
import com.digiwin.dap.middleware.dmc.common.utils.DMCUtils;
import com.digiwin.dmc.sdk.config.DmcUrl;
import com.digiwin.dmc.sdk.entity.BucketInfo;
import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.entity.UserRole;
import com.digiwin.dmc.sdk.identity.UserIdentity;
import com.digiwin.dmc.sdk.service.IBucketManagerService;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.service.impl.BucketManagerService;
import com.digiwin.dmc.sdk.service.impl.UserManagerService;

public final class ServerSetting {
    private static final IUserManagerService userManagerService = UserManagerService.userInstance();
    private static final IBucketManagerService bucketManagerService = BucketManagerService.bucketInstance();
    private static final UserIdentity identity = new UserIdentity();
    private static final UserIdentity admin = new UserIdentity();
    private static String serviceUrl;
    private static String bucketName;
    private static String identityName;
    private static String identityPwd;
    private static String identityAdminName;
    private static String identityAdminPwd;
    private static String appToken;
    private static String appSecret;

    public static String getServiceUrl() {
        return serviceUrl;
    }

    public static void setServiceUrl(String serviceUrl) {
        if (serviceUrl == null || serviceUrl.isEmpty()) {
            throw new IllegalArgumentException("serviceUrl is null");
        }
        ServerSetting.serviceUrl = serviceUrl;
        DmcUrl.setServiceUrl(serviceUrl);
        DmcUrl.setResourceUrl(serviceUrl + "/api/dmc/v1");
        DmcUrl.setFilesResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setUploadResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setDirectoriesResourceUrl(serviceUrl + "/api/dmc/v1/buckets/");
        DmcUrl.setFileMetadataResourceUrl(serviceUrl + "/drive/files/metadata");
        DmcUrl.setTokenResourceUrl(serviceUrl + "/api/dmc/v1/tokens");
        DmcUrl.setIdentityResourceUrl(serviceUrl + "/api/dmc/v1/auth");
        DmcUrl.setBucketResourceUrl(serviceUrl + "/api/dmc/v1/buckets");
        DmcUrl.setUserResourceUrl(serviceUrl + "/api/dmc/v1/users");
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static void setBucketName(String bucketName) {
        ServerSetting.bucketName = bucketName;
    }

    public static String getIdentityName() {
        return identityName;
    }

    public static void setIdentityName(String identityName) {
        ServerSetting.identityName = identityName;
        identity.setUserName(identityName);
    }

    public static String getIdentityPwd() {
        return identityPwd;
    }

    public static void setIdentityPwd(String identityPwd) {
        ServerSetting.identityPwd = identityPwd;
        identity.setPasswordHash(DMCUtils.sha256(identityPwd));
    }

    public static String getAppToken() {
        return appToken;
    }

    public static void setAppToken(String appToken) {
        ServerSetting.appToken = appToken;
    }

    public static String getAppSecret() {
        return appSecret;
    }

    public static void setAppSecret(String appSecret) {
        ServerSetting.appSecret = appSecret;
    }

    public static String getIdentityAdminName() {
        return identityAdminName;
    }

    public static void setIdentityAdminName(String identityAdminName) {
        ServerSetting.identityAdminName = identityAdminName;
        admin.setUserName(identityAdminName);
    }

    public static String getIdentityAdminPwd() {
        return identityAdminPwd;
    }

    public static void setIdentityAdminPwd(String identityAdminPwd) {
        ServerSetting.identityAdminPwd = identityAdminPwd;
        admin.setPasswordHash(DMCUtils.sha256(identityAdminPwd));
    }

    public static UserIdentity getUser() {
        return identity;
    }

    public static UserIdentity getAdmin() {
        return admin;
    }

    public static void initialize() {
        String isExistUser = userManagerService.isExistUser(identityName);
        String isExistBucket = bucketManagerService.isExistBucket(bucketName);
        if (!Boolean.parseBoolean(isExistUser)) {
            UserInfo user = new UserInfo(identityName, identityPwd, "sdk auto create", UserRole.BucketCreator);
            userManagerService.createUser(user);
        }
        if (!Boolean.parseBoolean(isExistBucket)) {
            BucketInfo bucket = new BucketInfo(bucketName, "sdk auto create");
            bucket.setOwner(identityName);
            bucketManagerService.createBucket(bucket);
        }
    }

    public static void check() {
        if (serviceUrl == null || serviceUrl.isEmpty()) {
            throw new DMCException("\u53c2\u6570\u9519\u8bef\uff1aserviceUrl\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (identityName == null || identityName.isEmpty()) {
            throw new DMCException("\u53c2\u6570\u9519\u8bef\uff1aidentityName\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (identityPwd == null || identityPwd.isEmpty()) {
            throw new DMCException("\u53c2\u6570\u9519\u8bef\uff1aidentityPwd\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (bucketName == null || bucketName.isEmpty()) {
            throw new DMCException("\u53c2\u6570\u9519\u8bef\uff1abucketName\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    public static DMC internal() {
        return Holder.instance;
    }

    private static class Holder {
        static final DMC instance = DMCBuilder.create().build();

        private Holder() {
        }
    }
}

