/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.download;

import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.model.DownloadRequest;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.service.download.IFileService;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.util.Map;

public class FileService
implements IFileService {
    private static volatile FileService fileService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static IFileService fileInstance() {
        if (fileService != null) return fileService;
        Class<FileService> clazz = FileService.class;
        synchronized (FileService.class) {
            if (fileService != null) return fileService;
            fileService = new FileService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return fileService;
        }
    }

    @Override
    public byte[] download(String fileId, TenantId ... tenantId) {
        return this.download((String)null, (String)null, fileId, (String)null, tenantId);
    }

    @Override
    public byte[] download(String bucketName, String fileId, TenantId ... tenantId) {
        return this.download((String)null, bucketName, fileId, (String)null, tenantId);
    }

    @Override
    @Deprecated
    public byte[] download(String discardTenantId, String bucketName, String fileId, TenantId ... tenantId) {
        return this.download(discardTenantId, bucketName, fileId, (String)null, tenantId);
    }

    @Override
    @Deprecated
    public byte[] download(String discardTenantId, String bucketName, String fileId, String driveToken, TenantId ... tenantId) {
        ArgumentUtils.download(fileId, tenantId);
        String bucket = ArgumentUtils.getBucketName(bucketName);
        Map<String, String> headers = HttpUtils.setHeader(driveToken, discardTenantId, tenantId);
        DownloadRequest request = new DownloadRequest();
        request.setBucket(bucket);
        request.setHeaders(headers);
        request.setFileId(fileId);
        return ServerSetting.internal().downloadV1(request);
    }
}

