/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.impl;

import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.UserInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.identity.UserIdentity;
import com.digiwin.dmc.sdk.service.IUserManagerService;
import com.digiwin.dmc.sdk.util.HttpRequestUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import com.digiwin.dmc.sdk.util.ObjectMapperUtil;
import com.digiwin.dmc.sdk.util.StringUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserManagerService
implements IUserManagerService {
    public static IUserManagerService userInstance() {
        return Holder.instance;
    }

    @Override
    public String createUser(UserInfo userInfo) {
        if (StringUtil.checkSpecialId(userInfo.getName())) {
            throw new IllegalArgumentException("userName\u4e3a\u7a7a\u6216\u5305\u542b\u7279\u6b8a\u5b57\u7b26.\u53f7\uff01");
        }
        HashMap<String, String> userObj = new HashMap<String, String>();
        userObj.put("name", userInfo.getName());
        userObj.put("pwdHash", userInfo.getPassword());
        userObj.put("displayName", userInfo.getDisplayName());
        userObj.put("builtinRole", userInfo.getRole().toString());
        try {
            String uri = String.format("%s/api/dmc/v1/users", ServerSetting.getServiceUrl());
            Map<String, String> headers = HttpUtils.setHeaderAdmin();
            Map responseEntity = HttpRequestUtil.postJson(uri, ObjectMapperUtil.writeValueAsString(userObj), headers, HashMap.class);
            if (responseEntity == null || !responseEntity.containsKey("user-id")) {
                return "";
            }
            return responseEntity.get("user-id").toString();
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public UserInfo getUser(String userName) {
        if (userName == null || userName.length() == 0) {
            throw new IllegalArgumentException("\u53c2\u6570userName is null");
        }
        String uri = String.format("%s/api/dmc/v1/users/%s", ServerSetting.getServiceUrl(), userName);
        Map<String, String> headers = HttpUtils.setHeaderAdmin();
        return HttpRequestUtil.get(uri, headers, UserInfo.class);
    }

    @Override
    public List<UserInfo> getUsers() {
        String uri = String.format("%s/api/dmc/v1/users", ServerSetting.getServiceUrl());
        Map<String, String> headers = HttpUtils.setHeaderAdmin();
        List users = HttpRequestUtil.get(uri, headers, ArrayList.class);
        ArrayList<UserInfo> userInfos = new ArrayList<UserInfo>();
        if (users != null) {
            for (Object user : users) {
                try {
                    String json = ObjectMapperUtil.writeValueAsString(user);
                    UserInfo userInfo = ObjectMapperUtil.readValue(json, UserInfo.class);
                    userInfos.add(userInfo);
                }
                catch (IOException e) {
                    throw new OperateException(e);
                }
            }
        }
        return userInfos;
    }

    @Override
    public String isExistUser(String userName) {
        Map<String, String> headers;
        if (userName == null) {
            throw new IllegalArgumentException("\u53c2\u6570userIdentity is null");
        }
        String uri = String.format("%s/api/dmc/v1/users/%s/isExist", ServerSetting.getServiceUrl(), userName);
        Map isExist = HttpRequestUtil.get(uri, headers = HttpUtils.setHeaderAdmin(), HashMap.class);
        if (isExist == null || !isExist.containsKey("isExist")) {
            return null;
        }
        return isExist.get("isExist").toString();
    }

    @Override
    public String getUserToken(UserIdentity userIdentity) {
        if (userIdentity == null) {
            throw new IllegalArgumentException("\u53c2\u6570userIdentity is null");
        }
        return ServerSetting.internal().getToken(userIdentity.getUserName(), userIdentity.getPasswordHash(), userIdentity.getTenantId());
    }

    private static class Holder {
        static final IUserManagerService instance = new UserManagerService();

        private Holder() {
        }
    }
}

