/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadV1Request;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.IGeneralDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class GeneralDocumentUploader
implements IGeneralDocumentUploader {
    private String discardTenantId;
    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private InputStream inputStream;
    private IUpLoadCallbackable completeCallback;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();

    private GeneralDocumentUploader(String discardTenantId, String bucketName, FileInfo fileInfo, String driveToken) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public GeneralDocumentUploader(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
    }

    public GeneralDocumentUploader(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        this.inputStream = new ByteArrayInputStream(bytes);
    }

    @Override
    public IGeneralDocumentUploader upload() {
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.discardTenantId, this.fileInfo, new TenantId[0]);
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Runnable runnable = () -> {
                try {
                    IamUserTokenHolder.setContext(iamUserToken);
                    UploadV1Request request = new UploadV1Request();
                    request.setBucket(this.bucketName);
                    request.setHeaders(headers);
                    request.setInput(this.inputStream);
                    String fileId = ServerSetting.internal().uploadV1(request).getId();
                    if (this.completeCallback != null) {
                        this.eventArgs.setFileId(fileId);
                        this.eventArgs.setPercentage(1.0);
                        this.completeCallback.callback(this.eventArgs);
                    }
                }
                finally {
                    IamUserTokenHolder.clearContext();
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    @Override
    public IGeneralDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }
}

