/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dmc.sdk.service.upload;

import com.digiwin.dap.middleware.dmc.common.context.IamUserTokenHolder;
import com.digiwin.dap.middleware.dmc.common.context.TenantId;
import com.digiwin.dap.middleware.dmc.internal.client.model.UploadPartV1Request;
import com.digiwin.dap.middleware.dmc.model.IamUserToken;
import com.digiwin.dmc.sdk.config.NetworkOptions;
import com.digiwin.dmc.sdk.config.ServerSetting;
import com.digiwin.dmc.sdk.entity.FileInfo;
import com.digiwin.dmc.sdk.exception.OperateException;
import com.digiwin.dmc.sdk.service.upload.ISegmentDocumentUploader;
import com.digiwin.dmc.sdk.service.upload.IUpLoadCallbackable;
import com.digiwin.dmc.sdk.service.upload.UploadProcessState;
import com.digiwin.dmc.sdk.service.upload.UploadProgressEventArgs;
import com.digiwin.dmc.sdk.util.ArgumentUtils;
import com.digiwin.dmc.sdk.util.ExecutorUtil;
import com.digiwin.dmc.sdk.util.HttpUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Map;

public class SegmentDocumentUploader
implements ISegmentDocumentUploader {
    private String discardTenantId;
    private String bucketName;
    private FileInfo fileInfo;
    private String driveToken;
    private int bufferSize = NetworkOptions.Default.getPackageSize();
    private InputStream inputStream;
    private IUpLoadCallbackable progressChangedCallback;
    private IUpLoadCallbackable completeCallback;
    private IUpLoadCallbackable errorCallback;
    private UploadProcessState state = UploadProcessState.NotStarted;
    private UploadProgressEventArgs eventArgs = new UploadProgressEventArgs();
    private String uploadId;

    private SegmentDocumentUploader(String discardTenantId, String bucketName, FileInfo fileInfo, String driveToken) {
        this.discardTenantId = discardTenantId;
        this.bucketName = bucketName;
        this.fileInfo = fileInfo;
        this.driveToken = driveToken;
    }

    public SegmentDocumentUploader(String discardTenantId, String bucketName, String localPath, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = Files.newInputStream(Paths.get(localPath, new String[0]), new OpenOption[0]);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    public SegmentDocumentUploader(String discardTenantId, String bucketName, byte[] bytes, FileInfo fileInfo, String driveToken) {
        this(discardTenantId, bucketName, fileInfo, driveToken);
        try {
            this.inputStream = new ByteArrayInputStream(bytes);
            this.eventArgs.setTotalBytes(this.inputStream.available());
        }
        catch (IOException e) {
            throw new OperateException(e);
        }
        this.eventArgs.setPercentage(0.0);
        this.eventArgs.setCompletedBytes(0);
    }

    @Override
    public ISegmentDocumentUploader beginUpload() {
        if (this.state != UploadProcessState.NotStarted) {
            throw new OperateException("\u4e0a\u4f20\u5df2\u5f00\u59cb\uff0c\u65e0\u6cd5\u518d\u6b21\u542f\u52a8\u4e0b\u8f7d\uff0c\u8bf7\u5f00\u542f\u65b0\u7684\u4e0a\u4f20");
        }
        try {
            this.bucketName = ArgumentUtils.getBucketName(this.bucketName);
            Map<String, String> headers = HttpUtils.setHeader(this.driveToken, this.discardTenantId, new TenantId[0]);
            this.uploadId = this.createEmptyFile(this.bucketName, headers);
            this.continueUpload();
            IamUserToken iamUserToken = IamUserTokenHolder.getContext();
            Runnable runnable = () -> {
                try {
                    IamUserTokenHolder.setContext(iamUserToken);
                    this.multipartUpload(this.bucketName, headers);
                }
                finally {
                    IamUserTokenHolder.clearContext();
                }
            };
            ExecutorUtil.newExecutor().execute(runnable);
            return this;
        }
        catch (Exception e) {
            throw new OperateException(e);
        }
    }

    private String createEmptyFile(String bucketName, Map<String, String> headers) throws Exception {
        UploadPartV1Request request = new UploadPartV1Request();
        request.setBucket(bucketName);
        request.setHeaders(headers);
        request.setFileInfo(this.fileInfo);
        return ServerSetting.internal().claimFileIdV1(request);
    }

    public void uploadSegFile(String bucketName, Map<String, String> headers, int from, int count, byte[] buf) {
        UploadPartV1Request request = new UploadPartV1Request();
        request.setBucket(bucketName);
        request.setHeaders(headers);
        request.setFileId(this.uploadId);
        request.setParts(buf);
        request.setFrom(from);
        request.setTo(from + count - 1);
        request.setTotal(this.eventArgs.getTotalBytes());
        ServerSetting.internal().uploadPartV1(request);
    }

    public void multipartUpload(String bucketName, Map<String, String> headers) {
        int totalBytes = this.eventArgs.getTotalBytes();
        int partCount = (int)Math.ceil((double)totalBytes / (double)this.bufferSize);
        try {
            for (int i = 0; i < partCount; ++i) {
                int curPartSize;
                int startPos = i * this.bufferSize;
                int n = curPartSize = i + 1 == partCount ? totalBytes - startPos : this.bufferSize;
                if (this.state == UploadProcessState.Stopped) break;
                if (this.state == UploadProcessState.Paused) {
                    Thread.sleep(86400000L);
                    if (this.state != UploadProcessState.Paused) continue;
                    this.state = UploadProcessState.Timeout;
                    break;
                }
                byte[] buffer = new byte[curPartSize];
                this.inputStream.read(buffer);
                this.uploadSegFile(bucketName, headers, startPos, curPartSize, buffer);
                this.eventArgs.setCompletedBytes(startPos + curPartSize);
                this.eventArgs.setPercentage((double)Math.round((double)this.eventArgs.getCompletedBytes() * 10000.0 / (double)totalBytes) / 10000.0);
                if (this.progressChangedCallback != null) {
                    this.progressChangedCallback.callback(this.eventArgs);
                }
                if (partCount - i != 1 || this.completeCallback == null) continue;
                this.eventArgs.setFileId(this.uploadId);
                this.completeCallback.callback(this.eventArgs);
            }
        }
        catch (Exception e) {
            if (this.errorCallback != null) {
                this.errorCallback.callback(this.eventArgs);
            }
            throw new OperateException(e);
        }
    }

    @Override
    public ISegmentDocumentUploader onProgressChanged(IUpLoadCallbackable callbackable) {
        this.progressChangedCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentUploader onCompleted(IUpLoadCallbackable callbackable) {
        this.completeCallback = callbackable;
        return this;
    }

    @Override
    public ISegmentDocumentUploader onError(IUpLoadCallbackable callbackable) {
        this.errorCallback = callbackable;
        return this;
    }

    @Override
    public void pauseUpload() {
        this.state = UploadProcessState.Paused;
    }

    @Override
    public void continueUpload() {
        this.state = UploadProcessState.Uploading;
    }

    @Override
    public void stopUpload() {
        this.state = UploadProcessState.Stopped;
    }
}

