/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.dap.middleware.dmc;

import com.digiwin.dap.middleware.dmc.ClientConfiguration;
import com.digiwin.dap.middleware.dmc.DMC;
import com.digiwin.dap.middleware.dmc.DMCBuilder;
import com.digiwin.dap.middleware.dmc.DMCClient;
import com.digiwin.dap.middleware.dmc.internal.DMCConfig;
import com.digiwin.dap.middleware.dmc.internal.DMCConfigBuilder;

public final class DMCClientBuilder
implements DMCBuilder {
    private final boolean lazy;

    public DMCClientBuilder(boolean lazy) {
        this.lazy = lazy;
    }

    @Override
    public DMC build() {
        DMCConfig config = DMCConfigBuilder.create().lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String tenantId) {
        DMCConfig config = DMCConfigBuilder.create().tenantId(tenantId).lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMC client, String tenantId) {
        client.switchTenantId(tenantId);
        return client;
    }

    @Override
    public DMC build(String uri, String username, String password, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).appToken(appToken).appSecret(appSecret).lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String tenantId, String bucket) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).tenantId(tenantId).lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(String uri, String username, String password, String tenantId, String bucket, String appToken, String appSecret) {
        DMCConfig config = DMCConfigBuilder.create(uri, username, password, bucket).appToken(appToken).appSecret(appSecret).tenantId(tenantId).lazy(this.lazy).build();
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMCConfig config) {
        return new DMCClient(config);
    }

    @Override
    public DMC build(DMCConfig config, ClientConfiguration clientConfig) {
        return new DMCClient(config, clientConfig);
    }
}

